/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.internal.SWTUtil;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class ResourcePool {
    private static Map devices = new WeakHashMap();
    private final Device device;
    private final Map fonts;
    private final Map colors;

    public static synchronized ResourcePool forDevice(Device device) {
        Util.notNull(device);
        ResourcePool.notDisposed(device);
        ResourcePool sharedGraphics = (ResourcePool)devices.get(device);
        if (sharedGraphics == null) {
            sharedGraphics = new ResourcePool(device);
            devices.put(device, sharedGraphics);
        }
        return sharedGraphics;
    }

    private static void notDisposed(Device device) {
        if (device.isDisposed()) {
            PaperClips.error(45);
        }
    }

    private ResourcePool(Device device) {
        this.device = device;
        this.fonts = new HashMap();
        this.colors = new HashMap();
    }

    public Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        ResourcePool.notDisposed(this.device);
        Font font = (Font)this.fonts.get(fontData);
        if (font == null) {
            font = new Font(this.device, fontData);
            this.fonts.put(SWTUtil.copy(fontData), font);
        }
        return font;
    }

    public Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        ResourcePool.notDisposed(this.device);
        Color color = (Color)this.colors.get(rgb);
        if (color == null) {
            color = new Color(this.device, rgb);
            this.colors.put(SWTUtil.copy(rgb), color);
        }
        return color;
    }
}

