/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.processing._impl;

import com.digitalpersona.onetouch.DPFPCaptureFeedback;
import com.digitalpersona.onetouch.DPFPFeatureSet;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPTemplate;
import com.digitalpersona.onetouch.jni.JniException;
import com.digitalpersona.onetouch.jni.Matcher;
import com.digitalpersona.onetouch.processing.DPFPEnrollment;
import com.digitalpersona.onetouch.processing.DPFPEnrollmentFactory;
import com.digitalpersona.onetouch.processing.DPFPImageQualityException;
import com.digitalpersona.onetouch.processing.DPFPTemplateStatus;
import java.util.Vector;

public class DPFPEnrollmentFactoryImpl
implements DPFPEnrollmentFactory {
    public DPFPEnrollment createEnrollment() {
        return new EnrollmentImpl();
    }

    private static class EnrollmentImpl
    implements DPFPEnrollment {
        private int featuresNeeded;
        private DPFPTemplate template;
        private DPFPTemplateStatus templateStatus = DPFPTemplateStatus.TEMPLATE_STATUS_UNKNOWN;
        private final Vector<DPFPFeatureSet> features = new Vector();
        private Matcher matcher;

        public EnrollmentImpl() {
            try {
                this.matcher = new Matcher();
                this.featuresNeeded = Matcher.getFeaturesRequired();
            }
            catch (JniException jniException) {
                throw new RuntimeException(jniException);
            }
        }

        public void addFeatures(DPFPFeatureSet dPFPFeatureSet) throws DPFPImageQualityException {
            if (this.templateStatus == DPFPTemplateStatus.TEMPLATE_STATUS_FAILED || this.templateStatus == DPFPTemplateStatus.TEMPLATE_STATUS_READY) {
                throw new IllegalStateException();
            }
            this.features.add(dPFPFeatureSet);
            this.templateStatus = DPFPTemplateStatus.TEMPLATE_STATUS_INSUFFICIENT;
            if (this.features.size() == this.featuresNeeded) {
                byte[][] byArrayArray = new byte[this.featuresNeeded][];
                for (int i = 0; i < this.featuresNeeded; ++i) {
                    byArrayArray[i] = this.features.elementAt(i).serialize();
                }
                try {
                    this.template = DPFPGlobal.getTemplateFactory().createTemplate(this.matcher.generateRegFeatures((byte[][])byArrayArray, 0));
                    this.templateStatus = DPFPTemplateStatus.TEMPLATE_STATUS_READY;
                }
                catch (JniException jniException) {
                    this.template = null;
                    this.templateStatus = DPFPTemplateStatus.TEMPLATE_STATUS_FAILED;
                    throw new DPFPImageQualityException(DPFPCaptureFeedback.CAPTURE_FEEDBACK_GOOD);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.template = null;
                    this.templateStatus = DPFPTemplateStatus.TEMPLATE_STATUS_FAILED;
                    throw new DPFPImageQualityException(DPFPCaptureFeedback.CAPTURE_FEEDBACK_NONE);
                }
            }
        }

        public void clear() {
            this.template = null;
            this.templateStatus = DPFPTemplateStatus.TEMPLATE_STATUS_UNKNOWN;
            this.features.clear();
        }

        public int getFeaturesNeeded() {
            return Math.max(this.featuresNeeded - this.features.size(), 0);
        }

        public DPFPTemplate getTemplate() {
            return this.template;
        }

        public DPFPTemplateStatus getTemplateStatus() {
            return this.templateStatus;
        }
    }
}

